; ====================================================================================================
;
; score.asm
;
; included from sprite.asm
;
; ====================================================================================================
SECTION code_user

CHRNO_SCORE:                        EQU 4       ; キャラクター番号

; ■スコアの点滅時間
SCORE_FLASHING_CNT:                 EQU $20

; ====================================================================================================
; 取得スコア初期化
; ====================================================================================================
INIT_SCORE:

    ; ■プレイヤーの座標の参照アドレスを取得
    PUSH IX
    LD A,1                          ; IX <- プレイヤーのワークアドレス
    CALL GET_SPR_WK_ADDR
    PUSH IX
    POP HL                          ; IX(転送元アドレス) -> HL
    POP IX

    LD (IX),CHRNO_SCORE             ; キャラクター番号=スコア

    INC HL
    INC HL
    LD A,(HL)
    LD (IX+1),0                     ; Y座標(小数部)
    LD (IX+2),A                     ; Y座標(整数部)

    INC HL
    INC HL
    LD A,(HL)
    SUB 8
    LD (IX+3),0                     ; X座標(小数部)
    LD (IX+4),A                     ; X座標(整数部)

    LD A,(SCORE_CHRNO)
    ADD A,28
    LD (IX+5),A                     ; スプライトパターンNo
    LD (IX+6),15                    ; カラーコード

    LD (IX+7),1                     ; 移動方向
    LD (IX+8),$FF                   ; 移動量
;    LD (IX+9),0                     ; アニメーションテーブルアドレス
;    LD (IX+10),0                    ; アニメーションテーブルアドレス
;    LD (IX+11),0                    ; アニメーションカウンタ
    LD (IX+12),0                    ; 点滅時間
    LD (IX+13),SCORE_FLASHING_CNT   ; 移動時間

    RET

; ====================================================================================================
; 獲得スコア処理
; ====================================================================================================
UPDATE_SCORE:

    CALL SPRITE_MOVE                ; スプライトキャラクター移動処理

    ; ■点滅を終えたか
    LD A,(IX+13)
    DEC A
    LD (IX+13),A
    OR A
    RET NZ

    ; ■点滅を終えた場合、自分自身を除去する
    CALL DEL_CHARACTER

    RET


; ====================================================================================================
; スコア加算サブルーチン
; スコアデータは3byteを前提とする。
; IN  : DE = 加算する値(BCD形式で1/100の値とする。
;            例)12000点＝0120
; ====================================================================================================
ADDSCORE:

	; ■1〜2桁目の加算
	LD HL,SCORE+2			    ; HLレジスタにスコアデータのアドレス(1〜2桁目)を設定
	LD A,E					    ; AレジスタにEレジスタの値をロード
    ADD A,(HL)			        ; Aレジスタの値に(IX+2)の値を加算
                                ; 桁溢れした場合はキャリーフラグが立つ
    DAA						    ; Aレジスタの値を内部10進に補正
    LD (HL),A				    ; Aレジスタの値を(IX+2)に格納
    
    ; ■3〜4桁目の加算
    DEC HL                      ; HLレジスタにスコアデータのアドレス(3〜4桁目)を設定
    LD A,D					    ; AレジスタにDレジスタの値をロード
    ADC A,(HL)			        ; Aレジスタの値に(IX+1)＋キャリーフラグを加算
    						    ; 桁溢れした場合はキャリーフラグが立つ
    DAA						    ; Aレジスタの値を内部10進に補正
    LD (HL),A				    ; Aレジスタの値を(IX+1)に格納
    
    ; ■5〜6桁目の加算
    DEC HL                      ; HLレジスタにスコアデータのアドレス(5〜6桁目)を設定
    LD A,0					    ; Aレジスタに0をロード
    ADC A,(HL)				    ; Aレジスタに(IX)＋キャリーフラグの値を加算
    						    ; 桁溢れした場合はキャリーフラグが立つ
                                ; が、これ以上桁がないので無視する
    DAA						    ; Aレジスタの値を内部10進に補正
    LD (HL),A				    ; Aレジスタの値を(IX)に格納    

    ; ■エクステンド判定
    LD A,(GAME_STATE)           ; ゲーム状態
    CP STATE_ALL_CLEAR          ; ゲーム状態：オールクリア
    RET Z                       ; オールクリア状態ならエクステンドせずに終了

    LD HL,NEXT_EXTEND_SCORE
    LD DE,SCORE
    LD B,3
ADDSCORE_L1:
    OR A
    LD A,(DE)                   ; A <- スコア
    INC DE                      ; 次の桁へ(2桁ずつ)
    SUB (HL)                    ; A=A-次回エクステンドスコア
    INC HL                      ; 次の桁へ(2桁ずつ)

    JP C,ADDSCORE_EXIT          ; スコア < 次回エクステンドスコアの場合は中断して抜ける

ADDSCORE_L2:
    DJNZ ADDSCORE_L1            ; 上位の桁がゼロの場合があるので、次の桁も調べる

    ; スコアが次回エクステンドスコアと同じ or 超えていたらここに入る
    ; エクステンド音
    LD Hl,SFX_02
    CALL SOUNDDRV_SFXPLAY

    ; 残機増加
    LD HL,LEFT
    INC (HL)
    CALL DRAW_INFO_INIT_L1      ; オフスクリーンに再表示

    ; 次回エクステンドスコア設定
    LD HL,NEXT_EXTEND_SCORE
    LD DE,$0500                 ; +50000pts
    CALL ADD_BCD_6

ADDSCORE_EXIT:
    RET


; ====================================================================================================
; ワークエリア
; プログラム起動時にcrtでゼロでramに設定される 
; ====================================================================================================
SECTION bss_user

; ■スコアのキャラクター番号
SCORE_CHRNO:
    DEFS 1

; ■スコア(BCD値)
;   ランキングデータの構造と合わせるため、スコア＋ラウンド数＋オールクリアフラグをここに定義する
SCORE:
    DEFS 3

; ■ラウンド数(BCD値)
ROUND_BCD:
    DEFS 1

; ■オールクリアフラグ
ALLCLEAR_FLG:
    DEFS 1

; ■スコア加算値(BCD値)
SCORE_ADDVALUE_BCD:
    DEFS 1

; ■次回エクステンドスコア(BCD値)
NEXT_EXTEND_SCORE:
    DEFS 3

